<?php
/**
 * The default template for displaying standard post format
 */

$post_class = '';
$featured = get_query_var( 'alavion_featured_disabled' );
if ( function_exists( 'FW' ) AND empty ( $featured ) ) {

	$featured_post = fw_get_db_post_option(get_The_ID(), 'featured');
	if ( !empty($featured_post) ) {

		$post_class = 'ltx-featured-post-none';
	}
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class( esc_attr($post_class) ); ?>>
	<?php 

		if ( has_post_thumbnail() ) {

			$alavion_photo_class = 'photo';
        	$alavion_layout = get_query_var( 'alavion_layout' );

			$alavion_image_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_The_ID()), 'full' );

			if ($alavion_image_src[2] > $alavion_image_src[1]) $alavion_photo_class .= ' vertical';
			
		    echo '<a href="'.esc_url(get_the_permalink()).'" class="'.esc_attr($alavion_photo_class).'">';

	    	if ( empty($alavion_layout) OR $alavion_layout == 'classic'  ) {

	    		the_post_thumbnail();
	    	}
	    		else
	    	if ( $alavion_layout == 'two-cols'  ) {	    	

	    		the_post_thumbnail();
	    	}
	    		else {


				$sizes_hooks = array( 'alavion-blog', 'alavion-blog-full' );
				$sizes_media = array( '1199px' => 'alavion-blog' );

				alavion_the_img_srcset( get_post_thumbnail_id(), $sizes_hooks, $sizes_media );
    		}

		    echo '</a>';

		}
	?>
    <div class="description">
    	<?php

    		alavion_get_the_post_headline();
    		
    	?>
        <a href="<?php esc_url( the_permalink() ); ?>" class="header"><h3><?php the_title(); ?></h3></a>
        <?php
			$alavion_display_excerpt = true;
			
        	if ( (!has_post_thumbnail() OR empty($alavion_layout)) OR !empty( $alavion_display_excerpt ) ):

        		if ( !empty( $alavion_display_excerpt ) AND $alavion_display_excerpt == 'visible' ):
        ?>
        <div class="text text-page">
			<?php
				add_filter( 'the_content', 'alavion_excerpt' );
			    if( strpos( $post->post_content, '<!--more-->' ) ) {

			        the_content( esc_html__( 'Read more', 'alavion' ) );
			    }
			    	else  {

			    	the_excerpt();			    	
			    }	
			?>
        </div>            
    	<?php 
    			else :

	    			echo '<a href="'.esc_url( get_the_permalink() ).'" class="more-link">'.esc_html__( 'Read more', 'alavion' ).'</a>';

    			endif;
   			else:
		    	echo '<a href="'.esc_url( get_the_permalink() ).'" class="more-link">'.esc_html__( 'Read more', 'alavion' ).'</a>';
    		endif;
    	?>
    </div>    
</article>