<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$alavion_choices =  array();
$alavion_choices['default'] = esc_html__( 'Default', 'alavion' );

$alavion_color_schemes = fw_get_db_settings_option( 'items' );
if ( !empty($alavion_color_schemes) ) {

	foreach ($alavion_color_schemes as $v) {

		$alavion_choices[$v['slug']] = esc_html( $v['name'] );
	}
}

$alavion_theme_config = alavion_theme_config();
$alavion_sections_list = alavion_get_sections();


$options = array(
	'general' => array(
		'title'   => esc_html__( 'Page settings', 'alavion' ),
		'type'    => 'box',
		'options' => array(		
			'general-box' => array(
				'title'   => __( 'General Settings', 'alavion' ),
				'type'    => 'tab',
				'options' => array(

					'margin-layout'    => array(
						'label' => esc_html__( 'Content Margin', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Margins control for content', 'alavion' ),
						'choices' => array(
							'default'  => esc_html__( 'Top And Bottom', 'alavion' ),
							'top'  => esc_html__( 'Top Only', 'alavion' ),
							'bottom'  => esc_html__( 'Bottom Only', 'alavion' ),
							'disabled' => esc_html__( 'Margin Removed', 'alavion' ),
						),
						'value' => 'default',
					),			
					'topbar-layout'    => array(
						'label' => esc_html__( 'Topbar section', 'alavion' ),
						'desc' => esc_html__( 'You can edit it in Sections menu of dashboard.', 'alavion' ),
						'type'    => 'select',
						'choices' => array('default' => 'Default') + array('hidden' => 'Hidden') + $alavion_sections_list['top_bar'],						
						'value'	=> 'default',
					),						
					'navbar-layout'    => array(
						'label' => esc_html__( 'Navbar', 'alavion' ),
						'type'    => 'select',
						'choices' => $alavion_theme_config['navbar'] + array( 'disabled'  	=> esc_html__( 'Hidden', 'alavion' ) ),
						'value' => $alavion_theme_config['navbar-default'],
					),								
					'header-layout'    => array(
						'label' => esc_html__( 'Page Header', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'default'  => esc_html__( 'Default', 'alavion' ),
							'disabled' => esc_html__( 'Hidden', 'alavion' ),
						),
						'value' => 'default',
					),						
					'subscribe-layout'    => array(
						'label' => esc_html__( 'Subscribe Block', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Subscribe block before footer. Can be edited from Sections Menu.', 'alavion' ),
						'choices' => array(
							'default'  => esc_html__( 'Default', 'alavion' ),
							'disabled' => esc_html__( 'Hidden', 'alavion' ),
						),
						'value' => 'default',
					),					
					'footer-layout'    => array(
						'label' => esc_html__( 'Footer', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block before footer. Edited in Widgets menu.', 'alavion' ),
						'choices' => $alavion_theme_config['footer'] + array( 'disabled'  	=> esc_html__( 'Hidden', 'alavion' ) ),
						'value' => $alavion_theme_config['footer-default'],
					),	
					'footer-parallax'    => array(
						'label' => esc_html__( 'Footer Parallax', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block parallax effect.', 'alavion' ),
						'choices' => array(
							'default'  => esc_html__( 'Default', 'alavion' ),
							'disabled' => esc_html__( 'Disabled', 'alavion' ),
						),
						'value' => 'default',
					),																			
					'color-scheme'    => array(
						'label' => esc_html__( 'Color Scheme', 'alavion' ),
						'type'    => 'select',
						'choices' => $alavion_choices,
						'value' => 'default',
					),								
				),											
			),	
			'cpt' => array(
				'title'   => esc_html__( 'Blog / Gallery', 'alavion' ),
				'type'    => 'tab',
				'options' => array(				
					'sidebar-layout'    => array(
						'label' => esc_html__( 'Blog Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden' => esc_html__( 'Hidden', 'alavion' ),
							'left'  => esc_html__( 'Sidebar Left', 'alavion' ),
							'right'  => esc_html__( 'Sidebar Right', 'alavion' ),
						),
						'value' => 'hidden',
					),						
					'blog-layout'    => array(
						'label' => esc_html__( 'Blog Layout', 'alavion' ),
						'description'   => esc_html__( 'Used only for blog pages.', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'default'  => esc_html__( 'Default', 'alavion' ),
							'classic'  => esc_html__( 'One Column', 'alavion' ),
							'two-cols' => esc_html__( 'Two Columns', 'alavion' ),
							'three-cols' => esc_html__( 'Three Columns', 'alavion' ),
						),
						'value' => 'default',
					),
					'gallery-layout'    => array(
						'label' => esc_html__( 'Gallery Layout', 'alavion' ),
						'description'   => esc_html__( 'Used only for gallery pages.', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'default' => esc_html__( 'Default', 'alavion' ),
							'col-2' => esc_html__( 'Two Columns', 'alavion' ),
							'col-3' => esc_html__( 'Three Columns', 'alavion' ),
							'col-4' => esc_html__( 'Four Columns', 'alavion' ),
						),
						'value' => 'default',
					),					
				)
			)	
		)
	),
);

unset($options['general']['options']['general-box']['options']['topbar-layout']);
unset($options['general']['options']['general-box']['options']['before-footer-layout']);
unset($options['general']['options']['general-box']['options']['color-scheme']);

