<?php if ( ! defined( 'ABSPATH' ) ) die( 'Forbidden' );
/**
 * Shortcode
 */

$args = get_query_var('like_sc_parallax_slider');

$class = '';
if ( !empty($args['class']) ) $class .= ' '. esc_attr($args['class']);
if ( !empty($args['id']) ) $id = ' id="'. esc_attr($args['id']). '"'; else $id = '';

$clouds = ltx_get_attachment_img_url($atts['clouds']);
$sky = ltx_get_attachment_img_url($atts['sky']);
$wing = ltx_get_attachment_img_url($atts['wing']);
$steam = ltx_get_attachment_img_url($atts['steam']);
$sun = ltx_get_attachment_img_url($atts['sun']);

?>
<div class="ltx-sky-slider <?php echo esc_attr($class); ?>" id="<?php echo esc_attr($id); ?>">
	<div class="ltx-slider-inner"><?php echo do_shortcode( $content ); ?></div>

	<?php if ( !empty($clouds[0]) ): ?> 
		<div id="ltx-sky-1" style="background-image:url(<?php echo esc_url($clouds[0]); ?>)"></div>
	<?php endif; ?>
	<?php if ( !empty($sky[0]) ): ?> 
		<div id="ltx-sky-2" style="background-image:url(<?php echo esc_url($sky[0]); ?>)"></div>
	<?php endif; ?>	
	<?php if ( !empty($sun[0]) ): ?> 
		<div id="ltx-sky-3" style="background-image:url(<?php echo esc_url($sun[0]); ?>)"></div>
	<?php endif; ?>	
	<?php if ( !empty($steam[0]) ): ?> 
		<div id="ltx-sky-4" style="background-image:url(<?php echo esc_url($steam[0]); ?>)"></div>
	<?php endif; ?>	
	<?php if ( !empty($wing[0]) ): ?> 
		<div id="ltx-wing" style="background-image:url(<?php echo esc_url($wing[0]); ?>)"></div>
	<?php endif; ?>	
</div>