<?php
/**
 * Navigation Bar
 */
$navbar_logo = $navlogo_class = $navbar_affix = '';
$navbar_layout = 'white';
$basket_icon = 'disabled';
$navbar_class = 'navbar-collapse collapse';
$navbar_mobile_width = '1198';


if ( function_exists( 'FW' ) ) {

	if ( is_404() ) {

		$navbar_layout = 'transparent';
		$navbar_logo = 'white';
	}	

	$navbar_affix = fw_get_db_settings_option( 'navbar-affix' );
	$navbar_breakpoint = fw_get_db_settings_option( 'navbar-breakpoint' );

	if ( !empty($navbar_breakpoint) ) {

		$navbar_mobile_width = $navbar_breakpoint;
	}

	// Current page layout
	$navbar_layout = alavion_get_navbar_layout('white');

	if ( $navbar_layout == 'full-width' OR $navbar_layout == 'hamburger' ) {

		$navbar_mobile_width = '4000';
		$navbar_logo = 'white';
	}

	if ( $navbar_layout == 'transparent' ) {

		$navbar_logo = 'white';
	}	

	$basket_icon = fw_get_db_settings_option( 'basket-icon' );
	if ( empty($basket_icon) ) {

		$basket_icon = 'disabled';
	}	

	if ( is_404() ) {

		$navbar_layout = 'transparent';
		$navbar_logo = 'white';
	}		
}

if ( $navbar_layout != 'disabled' ):

	alavion_the_topbar_block( $navbar_layout );

?>
<div id="nav-wrapper" class="navbar-layout-<?php echo esc_attr($navbar_layout);?>">
	<nav class="navbar" data-spy="<?php echo esc_attr($navbar_affix); ?>" data-offset-top="0">
		<div class="container">
			<?php
				if ( $navbar_layout == 'desktop-center' ) {

					alavion_the_navbar_social($navbar_layout);
				}
			?>				
			<div class="navbar-logo <?php echo esc_attr($navlogo_class); ?>">	
				<?php
					alavion_the_logo($navbar_logo);
				?>
			</div>	
			<?php
				if ( $navbar_layout == 'desktop-center' ) {

					alavion_the_navbar_icons( $navbar_layout );
				}

				if ( $navbar_layout == 'full-width' OR $navbar_layout == 'hamburger' ) {

					alavion_the_navbar_icons( $navbar_layout );
				}
			?>					
			<div id="navbar" class="<?php echo esc_attr( $navbar_class ); ?> navbar-mobile-white" data-mobile-screen-width="<?php echo esc_attr( $navbar_mobile_width ); ?>">
				<div class="toggle-wrap">
					<?php
						alavion_the_logo();
					?>						
					<button type="button" class="navbar-toggle collapsed">
						<span class="close">&times;</span>
					</button>							
					<div class="clearfix"></div>
				</div>
				<?php
					alavion_get_wp_nav_menu();

					if ( $navbar_layout != 'desktop-center' ) {

						alavion_the_navbar_icons( $navbar_layout );
					}
				?>
				<div class="mobile-controls">
					<?php
						alavion_the_navbar_icons( $navbar_layout, true );
					?>
				</div>				
			</div>
			<div class="navbar-controls">	
				<button type="button" class="navbar-toggle collapsed">
					<span class="icon-bar top-bar"></span>
					<span class="icon-bar middle-bar"></span>
					<span class="icon-bar bottom-bar"></span>
				</button>			
			</div>	
		</div>
	</nav>
</div>
<?php

endif;

