<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Theme Configuration and Custom CSS initializtion
 */

/**
 * Global theme config for header/footer/sections/colors/fonts
 */
if ( !function_exists('alavion_theme_config') ) {

	add_filter( 'ltx_get_theme_config', 'alavion_theme_config', 10, 1 );
	function alavion_theme_config() {

	    return array(
	    	'navbar'	=>	array(
				'white'  	=> esc_html__( 'Default. White Background', 'alavion' ),
				'transparent'  => esc_html__( 'Transparent for Dark Homepage Slider', 'alavion' ),		
				'transparent-white'  => esc_html__( 'Transparent for White Homepage Slider', 'alavion' ),		
				'desktop-center'  => esc_html__( 'Logo at the Center', 'alavion' ),		
				'hamburger'  => esc_html__( 'Desktop with Hamburger', 'alavion' ),		
				'full-width'  => esc_html__( 'Full-Width with Hamburger', 'alavion' ),		
			),
			'navbar-default' => 'white',

			'footer' => array(
				'default'  => esc_html__( 'Default', 'alavion' ),		
				'copyright'  => esc_html__( 'Copyright Only', 'alavion' ),		
				'copyright-transparent'  => esc_html__( 'Copyright Transparent', 'alavion' ),		
			),
			'footer-default' => 'default',

			'color_main'	=>	'#D3C19F',
			'color_second'	=>	'#AA3F44',
			'color_black'	=>	'#1E1F2D',
			'color_gray'	=>	'#F6F4EF',
			'color_white'	=>	'#FFFFFF',
			'color_red'		=>	'#AA3F44',
			'color_main_header'	=>	esc_html__( 'Peach', 'alavion' ),


			'font_main'					=>	'Merriweather',
			'font_main_var'				=>	'regular',
			'font_main_weights'			=>	'',
			'font_headers'				=>	'Barlow Condensed',
			'font_headers_var'			=>	'regular',
			'font_headers_weights'		=>	'700',
			'font_subheaders'			=>	'Barlow Condensed',
			'font_subheaders_var'		=>	'regular',
			'font_subheaders_weights'	=>	'700',
		);
	}
}

/**
 *  Color Palette
 */
function alavion_palette() {

	$cfg = alavion_theme_config();

    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'Main', 'alavion' ),
            'slug' => 'main-theme',
            'color' => $cfg['color_main'],
        ),
        array(
            'name' => esc_html__( 'Gray', 'alavion' ),
            'slug' => 'gray',
            'color' => $cfg['color_gray'],
        ),
        array(
            'name' => esc_html__( 'Black', 'alavion' ),
            'slug' => 'black',
            'color' => $cfg['color_black'],
        ),
        array(
            'name' => esc_html__( 'Red', 'alavion' ),
            'slug' => 'red',
            'color' => $cfg['color_red'],
        ),        
    ) );
}
add_action( 'after_setup_theme', 'alavion_palette', 10 );


/**
 * Get Google default font url
 */
if ( !function_exists('alavion_font_url') ) {

	function alavion_font_url() {

		$cfg = alavion_theme_config();
		$q = array();
		foreach ( array('font_main', 'font_headers', 'font_subheaders') as $item ) {

			if ( !empty($cfg[$item]) ) {

				$w = '';
				if ( !empty($cfg[$item.'_weights']) ) {

					$w .= ':'.$cfg[$item.'_weights'];
				}
				$q[] = $cfg[$item].$w;
			}
		}

		$query_args = array( 'family' => implode('|', $q), 'subset' => 'latin' );
		$font_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

		return esc_url( $font_url );
	}
}

/**
 * Config used for lt-ext plugin to set Visual Composer configuration
 */
if ( !function_exists('alavion_vc_config') ) {

	add_filter( 'ltx_get_vc_config', 'alavion_vc_config', 10, 1 );
	function alavion_vc_config( $value ) {

	    return array(
	    	'sections'	=>	array(
				esc_html__("Displaced floating section", 'alavion') 		=> "displaced-top",				
				esc_html__("Services in slider", 'alavion') 		=> "ltx-services-slider",				
				esc_html__("Special offer", 'alavion') 		=> "ltx-special-offer",				
				esc_html__("Private Flights", 'alavion') 		=> "ltx-private",				
			),
			'background' => array(
				esc_html__( "Main", 'alavion' ) => "theme_color",	
				esc_html__( "Second", 'alavion' ) => "second",	
				esc_html__( "Gray", 'alavion' ) => "gray",
				esc_html__( "White", 'alavion' ) => "white",
				esc_html__( "Black", 'alavion' ) => "black",			
			),
			'overlay'	=> array(
				esc_html__( "Black Overlay (60%)", 'alavion' ) => "black",
				esc_html__( "Dark Overlay (75%)", 'alavion' ) => "dark",
				esc_html__( "White Overlay", 'alavion' ) => "white",
			),
		);
	}
}


/*
* Adding additional TinyMCE options
*/
if ( !function_exists('alavion_mce_before_init_insert_formats') ) {

	add_filter('mce_buttons_2', 'alavion_wpb_mce_buttons_2');
	function alavion_wpb_mce_buttons_2( $buttons ) {

	    array_unshift($buttons, 'styleselect');
	    return $buttons;
	}

	add_filter( 'tiny_mce_before_init', 'alavion_mce_before_init_insert_formats' );
	function alavion_mce_before_init_insert_formats( $init_array ) {  

	    $style_formats = array(

	        array(  
	            'title' => esc_html__('Main Color', 'alavion'),
	            'block' => 'span',  
	            'classes' => 'color-main',
	            'wrapper' => true,
	        ),  
	        array(  
	            'title' => esc_html__('White Color', 'alavion'),
	            'block' => 'span',  
	            'classes' => 'color-white',
	            'wrapper' => true,   
	        ),
	        array(  
	            'title' => esc_html__('Large Text', 'alavion'),
	            'block' => 'span',  
	            'classes' => 'text-lg',
	            'wrapper' => true,
	        ),    
	        array(  
	            'title' => 'List Checkbox',
	            'selector' => 'ul',
	            'classes' => 'check',
	        ),       
	        array(  
	            'title' => 'Read More Link',
	            'selector' => 'a',
	            'classes' => 'more-link',
	        ),    	           
	    );  
	    $init_array['style_formats'] = json_encode( $style_formats );  
	     
	    return $init_array;  
	} 
}


/**
 * Register widget areas.
 *
 */
if ( !function_exists('alavion_action_theme_widgets_init') ) {

	add_action( 'widgets_init', 'alavion_action_theme_widgets_init' );
	function alavion_action_theme_widgets_init() {

		$span_class = 'widget-icon';

		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar Default', 'alavion' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Displayed in the right/left section of the site.', 'alavion' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar WooCommerce', 'alavion' ),
			'id'            => 'sidebar-wc',
			'description'   => esc_html__( 'Displayed in the right/left section of the site.', 'alavion' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 1', 'alavion' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'alavion' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 2', 'alavion' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'alavion' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 3', 'alavion' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'alavion' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 4', 'alavion' ),
			'id'            => 'footer-4',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'alavion' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget">',
			'after_title'   => '<span class="'.esc_attr($span_class).'"></span></h3>',
		) );			

	}
}



/**
 * Additional styles init
 */
if ( !function_exists('alavion_css_style') ) {

	add_action( 'wp_enqueue_scripts', 'alavion_css_style', 10 );
	function alavion_css_style() {

		global $wp_query;

		wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap-grid.css', array(), '1.0' );

		wp_enqueue_style( 'alavion-plugins-css', get_template_directory_uri() . '/assets/css/plugins.css', array(), wp_get_theme()->get('Version') );

		wp_enqueue_style( 'alavion-theme-style', get_stylesheet_uri(), array( 'bootstrap', 'alavion-plugins-css' ), wp_get_theme()->get('Version') );
	}
}


/**
 * Wp-admin styles and scripts
 */
if ( !function_exists('alavion_admin_init') ) {

	add_action( 'after_setup_theme', 'alavion_admin_init' );
	function alavion_admin_init() {

		add_action("admin_enqueue_scripts", 'alavion_admin_scripts');
	}

	function alavion_admin_scripts() {

		if ( function_exists('fw_get_db_settings_option') ) {

			$fontello['css'] = fw_get_db_settings_option( 'fontello-css' );
			$fontello['eot'] = fw_get_db_settings_option( 'fontello-eot' );
			$fontello['ttf'] = fw_get_db_settings_option( 'fontello-ttf' );
			$fontello['woff'] = fw_get_db_settings_option( 'fontello-woff' );
			$fontello['woff2'] = fw_get_db_settings_option( 'fontello-woff2' );
			$fontello['svg'] = fw_get_db_settings_option( 'fontello-svg' );

			if ( !empty($fontello['css']) AND !empty( $fontello['eot']) AND  !empty( $fontello['ttf']) AND  !empty( $fontello['woff']) AND  !empty( $fontello['woff2']) AND  !empty( $fontello['svg']) ) {

				wp_enqueue_style(  'alavion-fontello',  $fontello['css']['url'], array(), wp_get_theme()->get('Version') );

				$randomver = wp_get_theme()->get('Version');
				$css_content = "@font-face {
				font-family: 'alavion-fontello';
				  src: url('". esc_url ( $fontello['eot']['url']. "?" . $randomver )."');
				  src: url('". esc_url ( $fontello['eot']['url']. "?" . $randomver )."#iefix') format('embedded-opentype'),
				       url('". esc_url ( $fontello['woff2']['url']. "?" . $randomver )."') format('woff2'),
				       url('". esc_url ( $fontello['woff']['url']. "?" . $randomver )."') format('woff'),
				       url('". esc_url ( $fontello['ttf']['url']. "?" . $randomver )."') format('truetype'),
				       url('". esc_url ( $fontello['svg']['url']. "?" . $randomver )."#" . pathinfo(wp_basename( $fontello['svg']['url'] ), PATHINFO_FILENAME)  . "') format('svg');
				  font-weight: normal;
				  font-style: normal;
				}";

				wp_add_inline_style( 'alavion-fontello', $css_content );
			}

			wp_enqueue_script( 'alavion-theme-admin', get_template_directory_uri() . '/assets/js/scripts-admin.js', array( 'jquery' ) );
		}
	}
}




