<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * TGM Plugin Activation
 */

require_once get_template_directory() . '/tgm-plugin-activation/class-tgm-plugin-activation.php';

if ( !function_exists('alavion_action_theme_register_required_plugins') ) {

	function alavion_action_theme_register_required_plugins() {

		$config = array(

			'id'           => 'alavion',
			'menu'         => 'alavion-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => false,
			'is_automatic' => false,
		);

		tgmpa( array(

			array(
				'name'      => esc_html__('Unyson', 'alavion'),
				'slug'      => 'unyson',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('LT Extension', 'alavion'),
				'slug'      => 'lt-ext',
				'source'   	=> get_template_directory() . '/inc/plugins/lt-ext.zip',
				'version'   => '2.1.6',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('WPBakery Page Builder', 'alavion'),
				'slug'      => 'js_composer',
				'source'   	=> 'http://updates.like-themes.com/plugins/js_composer_6.zip',
				'required'  => true,
			),
			array(
				'name'      => esc_html__('Envato Market', 'alavion'),
				'slug'      => 'envato-market',
				'source'   	=> get_template_directory() . '/inc/plugins/envato-market.zip',
				'required'  => false,
			),													
			array(
				'name'      => esc_html__('Breadcrumb-navxt', 'alavion'),
				'slug'      => 'breadcrumb-navxt',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Contact Form 7', 'alavion'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('Contact Form 7 Multi Step', 'alavion'),
				'slug'      => 'cf7-multi-step',
				'source'   	=> get_template_directory() . '/inc/plugins/cf7-multi-step.zip',
				'required'  => false,
			),
			array(
				'name'       => esc_html__('MailChimp for WordPress', 'alavion'),
				'slug'       => 'mailchimp-for-wp',
				'required'   => false,
			),		
			array(
				'name'       => esc_html__('WooCommerce', 'alavion'),
				'slug'       => 'woocommerce',
				'required'   => false,
			),
			array(
				'name'      => esc_html__('Post-views-counter', 'alavion'),
				'slug'      => 'post-views-counter',
				'required'  => false,
			),			
			array(
				'name'      => esc_html__('User Profile Picture', 'alavion'),
				'slug'      => 'metronet-profile-picture',
				'required'  => false,
			),				
		), $config);
	}
}

add_action( 'tgmpa_register', 'alavion_action_theme_register_required_plugins' );

