<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$alavion_theme_config = alavion_theme_config();
$alavion_sections_list = alavion_get_sections();

$navbar_custom_assign = array();

if ( !empty( $alavion_theme_config['navbar'] ) AND is_array($alavion_theme_config['navbar']) AND sizeof( $alavion_theme_config['navbar']) > 1 ) {

	$menus = get_terms('nav_menu');
	if ( !empty($menus) ) {

		$list = array();
		foreach ( $menus as $item ) {

			$list[$item->term_id] = $item->name;
		}

		foreach ( $alavion_theme_config['navbar'] as $key => $val) {

			$navbar_custom_assign['navbar-'.$key.'-assign'] = array(
				'label' => sprintf( esc_html__( 'Navbar %s Assign', 'alavion' ), ucwords($key) ),
				'type'    => 'select',
				'desc' => esc_html__( 'You can assign additional menus for inner navbar.', 'alavion' ),
				'value' => 'default',
				'choices' => array('default' => esc_html__( 'Default', 'alavion' )) + $list,
			);
		}

		$navbar_custom_assign = array();
	}
}

$options = array(
	'general' => array(
		'title'   => esc_html__( 'General', 'alavion' ),
		'type'    => 'tab',
		'options' => array(
			'general-box' => array(
				'title'   => esc_html__( 'General Settings', 'alavion' ),
				'type'    => 'tab',
				'options' => array(						
					'page-loader'    => array(
						'type'    => 'multi-picker',
						'picker'       => array(
							'loader' => array(
								'label'   => esc_html__( 'Page Loader', 'alavion' ),
								'type'    => 'select',
								'choices' => array(
									'disabled' => esc_html__( 'Disabled', 'alavion' ),
									'image' => esc_html__( 'Image', 'alavion' ),
									'enabled' => esc_html__( 'Theme Loader', 'alavion' ),
								),
								'value' => 'enabled'
							)
						),						
						'choices' => array(
							'image' => array(
								'loader_img'    => array(
									'label' => esc_html__( 'Page Loader Image', 'alavion' ),
									'type'  => 'upload',
								),
							),
						),
						'value' => 'enabled',
					),	
					'google_api'    => array(
						'label' => esc_html__( 'Google Maps API Key', 'alavion' ),
						'desc'  => esc_html__( 'Required for contacts page, also used in widget', 'alavion' ),
						'type'  => 'text',
					),								
				),
			),
			'logo' => array(
				'title'   => esc_html__( 'Logo and Media', 'alavion' ),
				'type'    => 'tab',
				'options' => array(	
					'logo-box' => array(
						'title'   => esc_html__( 'Logo', 'alavion' ),
						'type'    => 'box',
						'options' => array(			
							'favicon'    => array(
								'html' => esc_html__( 'To change Favicon go to Appearance -> Customize -> Site Identity', 'alavion' ),
								'type'  => 'html',
							),							
							'logo'    => array(
								'label' => esc_html__( 'Logo Black', 'alavion' ),
								'type'  => 'upload',
							),
							'logo_2x'    => array(
								'label' => esc_html__( 'Logo Black 2x', 'alavion' ),
								'type'  => 'upload',
							),	
							'logo_white'    => array(
								'label' => esc_html__( 'Logo White', 'alavion' ),
								'type'  => 'upload',
							),
							'logo_white_2x'    => array(
								'label' => esc_html__( 'Logo White 2x', 'alavion' ),
								'type'  => 'upload',
							),		
							'widgets_bg'    => array(
								'label' => esc_html__( 'Sidebar Widgets Background', 'alavion' ),
								'type'  => 'upload',
							),									
							'404_bg'    => array(
								'label' => esc_html__( '404 Background', 'alavion' ),
								'type'  => 'upload',
							),						
						),
					),
				),
			),				
		),
	),
	'header' => array(
		'title'   => esc_html__( 'Header', 'alavion' ),
		'type'    => 'tab',
		'options' => array(
			'header-box-2' => array(
				'title'   => esc_html__( 'Navbar', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'navbar-default'    => array(
						'label' => esc_html__( 'Navbar Default', 'alavion' ),
						'type'    => 'select',
						'value' => $alavion_theme_config['navbar-default'],
						'choices' => $alavion_theme_config['navbar'],
					),	
					'navbar-default-force'    => array(
						'label' => esc_html__( 'Navbar Default Override', 'alavion' ),
						'desc'   => esc_html__( 'By default every page can have unqiue navbar setting. You can override them here.', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled. Every page uses its own settings', 'alavion' ),
							'force'  => esc_html__( 'Enabled. Override all site pages and use Navbar Default', 'alavion' ),
						),
						'value' => 'disabled',
					),						
					'navbar-affix'    => array(
						'label' => esc_html__( 'Navbar Sticked', 'alavion' ),
						'desc'   => esc_html__( 'May not work with all navbar types', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'' => esc_html__( 'Allways Static', 'alavion' ),
							'affix'  => esc_html__( 'Desktop Sticked', 'alavion' ),
						),
						'value' => '',
					),
					'navbar-breakpoint'    => array(
						'label' => esc_html__( 'Navbar Mobile Breakpoint, px', 'alavion' ),
						'desc'   => esc_html__( 'Mobile menu will be displayed in viewports below this value', 'alavion' ),
						'type'    => 'text',
						'value' => '1198',
					),						
					$navbar_custom_assign,
				)
			),
			'header-box-topbar' => array(
				'title'   => esc_html__( 'Topbar', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'topbar-info'    => array(
						'label' => ' ',
						'type'    => 'html',
						'html' => esc_html__( 'You can edit topbar in sections menu of dashboard', 'alavion' ),
					),					
					'topbar'    => array(
						'label' => esc_html__( 'Topbar visibility', 'alavion' ),
						'desc'   => esc_html__( 'You can edit topbar layout in Sections menu', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'visible'  => esc_html__( 'Always Visible', 'alavion' ),
							'desktop'  => esc_html__( 'Desktop Visible', 'alavion' ),
							'desktop-tablet'  => esc_html__( 'Desktop and Tablet Visible', 'alavion' ),
							'mobile'  => esc_html__( 'Mobile only Visible', 'alavion' ),
							'hidden' => esc_html__( 'Hidden', 'alavion' ),
						),
						'value' => 'hidden',
					),					
					'topbar-section'    => array(
						'label' => esc_html__( 'Topbar section', 'alavion' ),
						'desc' => esc_html__( 'You can edit it in Sections menu of dashboard.', 'alavion' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $alavion_sections_list['top_bar'],						
						'value'	=> '',
					),						
				)
			),			
			'header-box-icons' => array(
				'title'   => esc_html__( 'Icons and Elements', 'alavion' ),
				'type'    => 'tab',
				'options' => array(		
					'icons-info'    => array(
						'label' => ' ',
						'type'    => 'html',
						'html' => esc_html__( 'Icons can be displayed in topbar using shortcode: [ltx-navbar-icons]', 'alavion' ),
					),																
					'navbar-icons' => array(
		                'label' => esc_html__( 'Navbar / Topbar Icons', 'alavion' ),
		                'desc' => esc_html__( 'Depends on theme style', 'alavion' ),
		                'type' => 'addable-box',
		                'value' => array(),
		                'box-options' => array(
							'type'        => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'type_radio' => array(
										'label'   => esc_html__( 'Type', 'alavion' ),
										'type'    => 'radio',
										'choices' => array(
											'search' => esc_html__( 'Search', 'alavion' ),
											'basket'  => esc_html__( 'WooCommerce Cart', 'alavion' ),
											'profile'  => esc_html__( 'User Profile', 'alavion' ),
											'social'  => esc_html__( 'Social Icon', 'alavion' ),
										),
									)
								),
								'choices'      => array(
									'basket'  => array(
										'count'    => array(
											'label' => esc_html__( 'Count', 'alavion' ),
											'type'    => 'select',
											'choices' => array(
												'show' => esc_html__( 'Show count label', 'alavion' ),
												'hide'  => esc_html__( 'Hide count label', 'alavion' ),
											),
											'value' => 'show',
										),											
									),
									'profile'  => array(
					                    'header' => array(
					                        'label' => esc_html__( 'Non-logged header', 'alavion' ),
					                        'type' => 'text',
					                        'value' => '',
					                    ),										
									),
									'social'  => array(
					                    'text' => array(
					                        'label' => esc_html__( 'Label', 'alavion' ),
					                        'type' => 'text',
					                    ),
					                    'href' => array(
					                        'label' => esc_html__( 'External Link', 'alavion' ),
					                        'type' => 'text',
					                        'value' => '#',
					                    ),											
									),		
								),
								'show_borders' => false,
							),	  														                	
							'icon-type'        => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'value'        => array(
									'icon_radio' => 'default',
								),
								'picker'       => array(
									'icon_radio' => array(
										'label'   => esc_html__( 'Icon', 'alavion' ),
										'type'    => 'radio',
										'choices' => array(
											'default'  => esc_html__( 'Default', 'alavion' ),
											'fa' => esc_html__( 'FontAwesome', 'alavion' )
										),
										'desc'    => esc_html__( 'For social icons you need to use FontAwesome in any case.',
											'alavion' ),
									)
								),
								'choices'      => array(
									'default'  => array(
									),
									'fa' => array(
										'icon_v2'  => array(
											'type'  => 'icon-v2',
											'label' => esc_html__( 'Select Icon', 'alavion' ),
										),										
									),
								),
								'show_borders' => false,
							),
							'icon-visible'        => array(
								'label'   => esc_html__( 'Visibility', 'alavion' ),
								'type'    => 'radio',
								'value'    => 'hidden-mob',								
								'choices' => array(
									'hidden-mob'  => esc_html__( 'Hidden on mobile', 'alavion' ),
									'visible-mob' => esc_html__( 'Visible on mobile', 'alavion' )
								),
							),							
							'profile-name'        => array(
								'label'   => esc_html__( 'Profile Name', 'alavion' ),
								'type'    => 'radio',
								'value'    => 'hidden',								
								'choices' => array(
									'hidden'  => esc_html__( 'Hidden', 'alavion' ),
									'visible' => esc_html__( 'Visible', 'alavion' )
								),
							),								
		                ),
                		'template' => '{{- type.type_radio }}',		                
                    ),
					'basket-icon'    => array(
						'label' => esc_html__( 'Basket icon in navbar', 'alavion' ),
						'desc'   => esc_html__( 'As replacement for basket in topbar in mobile view', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Hidden', 'alavion' ),
							'mobile'  => esc_html__( 'Visible on Mobile', 'alavion' ),
						),
						'value' => 'disabled',
					),					
				),
			),
			'header-box-1' => array(
				'title'   => esc_html__( 'Page Header H1', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'pageheader-display'    => array(
						'label' => esc_html__( 'Page Header Visibility', 'alavion' ),
						'desc'   => esc_html__( 'Status of Page Header with H1 and Breadcrumbs', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'default' => esc_html__( 'Default', 'alavion' ),
							'disabled'  => esc_html__( 'Force Hidden on all Pages', 'alavion' ),
						),
						'value' => 'fixed',
					),		
					'pageheader-overlay'    => array(
						'label' => esc_html__( 'Page Header Overlay', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
						),
						'value' => 'enabled',
					),										
					'header_bg'    => array(
						'label' => esc_html__( 'Inner Pages Header Background', 'alavion' ),
						'desc'  => esc_html__( 'By default header is gray, you can replace it with background image', 'alavion' ),
						'type'  => 'upload',
					),  				
					'wc_bg'    => array(
						'label' => esc_html__( 'WooCommerce Header Background', 'alavion' ),
						'desc'  => esc_html__( 'Used only for WooCommerce pages', 'alavion' ),
						'type'  => 'upload',
					),  					
					'header_fixed'    => array(
						'label' => esc_html__( 'Background parallax', 'alavion' ),
						'desc'   => esc_html__( 'Parallax effect requires large images', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled', 'alavion' ),
							'fixed'  => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'fixed',
					),
					'featured_bg'    => array(
						'label' => esc_html__( 'Featured Images as Background', 'alavion' ),
						'desc'  => esc_html__( 'Use Featured Image for Page as Header Background for all the pages', 'alavion' ),
						'type'    => 'select',						
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'disabled',
					),	
					'tagline'    => array(
						'label' => esc_html__( 'Header Tagline', 'alavion' ),
						'desc'  => esc_html__( 'Visible on left side of inner page header', 'alavion' ),
						'type'  => 'text',
					),
					'header-social'    => array(
						'label' => esc_html__( 'Social icons in page header', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'enabled',
					),	

				),
			),
		),
	),	
	'footer' => array(
		'title'   => esc_html__( 'Footer', 'alavion' ),
		'type'    => 'tab',
		'options' => array(

			'footer-box-1' => array(
				'title'   => esc_html__( 'Widgets', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'footer-layout-default'    => array(
						'label' => esc_html__( 'Footer Default Style', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block before copyright. Edited in Widgets menu.', 'alavion' ),
						'choices' => $alavion_theme_config['footer'],
						'value' => $alavion_theme_config['footer-default'],
					),						
					'footer_widgets'    => array(
						'label' => esc_html__( 'Enable Footer Widgets', 'alavion' ),
						'desc'   => esc_html__( 'Widgets controled in Appearance -> Widgets. Column will be hidden, then no active widgets exists', 'alavion' ),	
						'type'  => 'checkbox',
						'value'	=> 'true',
					),					
					'footer-parallax'    => array(
						'label' => esc_html__( 'Footer Parallax', 'alavion' ),
						'type'    => 'select',							
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'disabled',
					),						
					'footer_bg'    => array(
						'label' => esc_html__( 'Footer Background', 'alavion' ),
						'type'  => 'upload',
					),		
					'footer-box-1-1' => array(
						'title'   => esc_html__( 'Desktop widgets visibility', 'alavion' ),
						'type'    => 'box',
						'options' => array(

							'footer_1_hide'    => array(
								'label' => esc_html__( 'Footer 1', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),						
							),
							'footer_2_hide'    => array(
								'label' => esc_html__( 'Footer 2', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
							'footer_3_hide'    => array(
								'label' => esc_html__( 'Footer 3', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
							'footer_4_hide'    => array(
								'label' => esc_html__( 'Footer 4', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
						)
					),
					'footer-box-1-2' => array(
						'title'   => esc_html__( 'Notebook widgets visibility', 'alavion' ),
						'type'    => 'box',
						'options' => array(

							'footer_1__hide_md'    => array(
								'label' => esc_html__( 'Footer 1', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),						
							),
							'footer_2_hide_md'    => array(
								'label' => esc_html__( 'Footer 2', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
							'footer_3_hide_md'    => array(
								'label' => esc_html__( 'Footer 3', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
							'footer_4_hide_md'    => array(
								'label' => esc_html__( 'Footer 4', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),	
							),
						)
					),					
					'footer-box-1-3' => array(
						'title'   => esc_html__( 'Mobile widgets visibility', 'alavion' ),
						'type'    => 'box',
						'options' => array(
							'footer_1_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 1', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),
							),
							'footer_2_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 2', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),
							),
							'footer_3_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 3', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),
							),
							'footer_4_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 4', 'alavion' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'alavion'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'alavion'),
								),
							),														
						)
					)
				),
			),
			'footer-box-subscribe' => array(
				'title'   => esc_html__( 'Subscribe and Other', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'footer-sections'    => array(
						'html' => esc_html__( 'You can edit all items in Sections menu of dashboard.', 'alavion' ),
						'type'  => 'html',
					),							
					'subscribe-section'    => array(
						'label' => esc_html__( 'Subscribe block', 'alavion' ),
						'desc' => esc_html__( 'Section displayed before widgets on every page. You can hide in on certain page in page settings.', 'alavion' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $alavion_sections_list['subscribe'],						
						'value'	=> '',
					),
					'before-footer-section'    => array(
						'label' => esc_html__( 'Before Footer section', 'alavion' ),
						'desc' => esc_html__( 'Section displayed under all content before subscribe/widgets.', 'alavion' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $alavion_sections_list['before_footer'],
						'value'	=> '',
					),					
				),
			),	
			'footer-box-2' => array(
				'title'   => esc_html__( 'Go Top', 'alavion' ),
				'type'    => 'tab',
				'options' => array(															
					'go_top_visibility'    => array(
						'label' => esc_html__( 'Go Top Visibility', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'visible'  => esc_html__( 'Always visible', 'alavion' ),
							'desktop' => esc_html__( 'Desktop Only', 'alavion' ),
							'mobile' => esc_html__( 'Mobile Only', 'alavion' ),
							'hidden' => esc_html__( 'Hidden', 'alavion' ),
						),						
						'value'	=> 'visible',
					),		
					'go_top_pos'    => array(
						'label' => esc_html__( 'Go Top Position', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'floating'  => esc_html__( 'Floating', 'alavion' ),
							'static' => esc_html__( 'Static at the footer', 'alavion' ),
						),						
						'value'	=> 'floating',
					),		
					'go_top_img'    => array(
						'label' => esc_html__( 'Go Top Image', 'alavion' ),
						'type'  => 'upload',
					),		
					'go_top_text'    => array(
						'label' => esc_html__( 'Go Top Text', 'alavion' ),
						'type'  => 'text',
					),														
				),
			),
			'footer-box-3' => array(
				'title'   => esc_html__( 'Copyrights', 'alavion' ),
				'type'    => 'tab',
				'options' => array(																							
					'copyrights'    => array(
						'label' => esc_html__( 'Copyrights', 'alavion' ),
						'type'  => 'wp-editor',
					),									
				),
			),					
		),
	),	
	'layout' => array(
		'title'   => esc_html__( 'Posts Layout', 'alavion' ),
		'type'    => 'tab',
		'options' => array(

			'layout-box-1' => array(
				'title'   => esc_html__( 'Blog Posts', 'alavion' ),
				'type'    => 'tab',
				'options' => array(

					'blog_layout'    => array(
						'label' => esc_html__( 'Blog Layout', 'alavion' ),
						'desc'   => esc_html__( 'Default blog page layout.', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'classic'  => esc_html__( 'One Column', 'alavion' ),
							'two-cols' => esc_html__( 'Two Columns', 'alavion' ),
							'three-cols' => esc_html__( 'Three Columns', 'alavion' ),
						),
						'value' => 'classic',
					),				
					'blog_list_sidebar'    => array(
						'label' => esc_html__( 'Blog List Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'right',
					),				
					'blog_post_sidebar'    => array(
						'label' => esc_html__( 'Blog Post Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'right',
					),																				
					'excerpt_auto'    => array(
						'label' => esc_html__( 'Excerpt Classic Blog Size', 'alavion' ),
						'desc'  => esc_html__( 'Automaticly cuts content for blogs', 'alavion' ),
						'value'	=> 350,
						'type'  => 'short-text',
					),
					'excerpt_masonry_auto'    => array(
						'label' => esc_html__( 'Excerpt Masonry Blog Size', 'alavion' ),
						'desc'  => esc_html__( 'Automaticly cuts content for blogs', 'alavion' ),
						'value'	=> 150,
						'type'  => 'short-text',
					),
					'blog_gallery_autoplay'    => array(
						'label' => esc_html__( 'Gallery post type autoplay, ms', 'alavion' ),
						'desc'  => esc_html__( 'Set 0 to disable autoplay', 'alavion' ),
						'type'  => 'text',
						'value' => '4000',
					),						
				)
			),
			'layout-box-2' => array(
				'title'   => esc_html__( 'Services', 'alavion' ),
				'type'    => 'tab',
				'options' => array(	
					'services_list_layout'    => array(
						'label' => esc_html__( 'Services List Layout', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'classic'  => esc_html__( 'One Column', 'alavion' ),
							'two-cols' => esc_html__( 'Two Columns', 'alavion' ),
							'three-cols' => esc_html__( 'Three Columns', 'alavion' ),
						),
						'value' => 'two-cols',
					),						
					'services_list_sidebar'    => array(
						'label' => esc_html__( 'Services List Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'hidden',
					),				
					'services_post_sidebar'    => array(
						'label' => esc_html__( 'Services Post Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'hidden',
					),					
				)
			),
			'layout-box-3' => array(
				'title'   => esc_html__( 'WooCommerce', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'shop_list_sidebar'    => array(
						'label' => esc_html__( 'WooCommerce List Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'left',
					),				
					'shop_post_sidebar'    => array(
						'label' => esc_html__( 'WooCommerce Product Sidebar', 'alavion' ),
						'desc'   => esc_html__( 'Blog Post Sidebar', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'alavion' ),
							'left' => esc_html__( 'Left', 'alavion' ),
							'right' => esc_html__( 'Right', 'alavion' ),
						),
						'value' => 'hidden',
					),											
					'excerpt_wc_auto'    => array(
						'label' => esc_html__( 'Excerpt WooCommerce Size', 'alavion' ),
						'desc'  => esc_html__( 'Automaticly cuts description for products', 'alavion' ),
						'value'	=> 50,
						'type'  => 'short-text',
					),		
					'wc_zoom'    => array(
						'label' => esc_html__( 'WooCommerce Product Hover Zoom', 'alavion' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Enables mouse hover zoom in single product page', 'alavion' ),
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'disabled',
					),
					'wc_columns'    => array(
						'label' => esc_html__( 'Columns number', 'alavion' ),
						'desc'  => esc_html__( 'Overrides default WooCommerce settings', 'alavion' ),
						'type'  => 'text',
						'value' => '3',
					),
					'wc_per_page'    => array(
						'label' => esc_html__( 'Products per Page', 'alavion' ),
						'type'  => 'text',
						'value' => '6',
					),
					'wc_show_list_excerpt'    => array(
						'label' => esc_html__( 'Display Excerpt in Shop List', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'enabled',
					),					
					'wc_show_list_rate'    => array(
						'label' => esc_html__( 'Display Rate in Shop List', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'enabled',
					),
					'wc_show_list_attr'    => array(
						'label' => esc_html__( 'Display Attributes in Shop List', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'alavion' ),
							'enabled' => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'disabled',
					),															
				)
			),
			'layout-box-4' => array(
				'title'   => esc_html__( 'Gallery', 'alavion' ),
				'type'    => 'tab',
				'options' => array(													
					'gallery_layout'    => array(
						'label' => esc_html__( 'Default Gallery Layout', 'alavion' ),
						'desc'   => esc_html__( 'Default galley page layout.', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'col-2' => esc_html__( 'Two Columns', 'alavion' ),
							'col-3' => esc_html__( 'Three Columns', 'alavion' ),
							'col-4' => esc_html__( 'Four Columns', 'alavion' ),
						),
						'value' => 'col-2',
					),						
				)
			)
		)
	),
	'fonts' => array(
		'title'   => esc_html__( 'Fonts', 'alavion' ),
		'type'    => 'tab',
		'options' => array(

			'fonts-box' => array(
				'title'   => esc_html__( 'Fonts Settings', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'font-main'                => array(
						'label' => __( 'Main Font', 'alavion' ),
						'type'  => 'typography-v2',
						'desc'	=>	esc_html__( 'Use https://fonts.google.com/ to find font you need', 'alavion' ),
						'value'      => array(
							'family'    => $alavion_theme_config['font_main'],
							'subset'    => 'latin-ext',
							'variation' => $alavion_theme_config['font_main_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-main-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'alavion' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "800,900"', 'alavion' ),
						'type'  => 'text',
						'value'  => $alavion_theme_config['font_main_weights'],							
					),											
					'font-headers'                => array(
						'label' => __( 'Headers Font', 'alavion' ),
						'type'  => 'typography-v2',
						'value'      => array(
							'family'    => $alavion_theme_config['font_headers'],
							'subset'    => 'latin-ext',
							'variation' => $alavion_theme_config['font_headers_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-headers-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'alavion' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "600,800"', 'alavion' ),
						'type'  => 'text',
						'value'  => $alavion_theme_config['font_headers_weights'],						
					),
					'font-subheaders'                => array(
						'label' => __( 'SubHeaders Font', 'alavion' ),
						'type'  => 'typography-v2',
						'value'      => array(
							'family'    => $alavion_theme_config['font_subheaders'],
							'subset'    => 'latin-ext',
							'variation' => $alavion_theme_config['font_subheaders_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-subheaders-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'alavion' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "600,800"', 'alavion' ),
						'type'  => 'text',
						'value'  => $alavion_theme_config['font_subheaders_weights'],						
					),							
				),
			),
			'fontello-box' => array(
				'title'   => esc_html__( 'Fontello', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'fontello-css'    => array(
						'label' => esc_html__( 'Fontello Codes CSS', 'alavion' ),
						'desc'  => esc_html__( 'Upload *-codes.css postfix file here', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),		
					'fontello-ttf'    => array(
						'label' => esc_html__( 'Fontello TTF', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-eot'    => array(
						'label' => esc_html__( 'Fontello EOT', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-woff'    => array(
						'label' => esc_html__( 'Fontello WOFF', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-woff2'    => array(
						'label' => esc_html__( 'Fontello WOFF2', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-svg'    => array(
						'label' => esc_html__( 'Fontello SVG', 'alavion' ),
						'type'  => 'upload',
						'images_only' => false,
					),												
				),
			),

		),
	),	
	'social' => array(
		'title'   => esc_html__( 'Social', 'alavion' ),
		'type'    => 'tab',
		'options' => array(
			'social-box' => array(
				'title'   => esc_html__( 'Social', 'alavion' ),
				'type'    => 'tab',
				'options' => array(
					'target-social'    => array(
						'label' => esc_html__( 'Open social links in', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'self'  => esc_html__( 'Same window', 'alavion' ),
							'blank' => esc_html__( 'New window', 'alavion' ),
						),
						'value' => 'self',
					),															
		            'social-icons' => array(
		                'label' => esc_html__( 'Social Icons', 'alavion' ),
		                'type' => 'addable-box',
		                'value' => array(),
		                'desc' => esc_html__( 'Visible in inner page header', 'alavion' ),
		                'box-options' => array(
		                    'icon_v2' => array(
		                        'label' => esc_html__( 'Icon', 'alavion' ),
		                        'type'  => 'icon-v2',
		                    ),
		                    'text' => array(
		                        'label' => esc_html__( 'Text', 'alavion' ),
		                        'desc' => esc_html__( 'If needed', 'alavion' ),
		                        'type' => 'text',
		                    ),
		                    'href' => array(
		                        'label' => esc_html__( 'Link', 'alavion' ),
		                        'type' => 'text',
		                        'value' => '#',
		                    ),		                    
		                ),
                		'template' => '{{- text }}',		                
                    ),								
				),
			),
		),
	),	
	'colors' => array(
		'title'   => esc_html__( 'Colors Schemes', 'alavion' ),
		'type'    => 'tab',
		'options' => array(			
			'schemes-box' => array(
				'title'   => esc_html__( 'Additional Color Schemes Settings', 'alavion' ),
				'type'    => 'box',
				'options' => array(
					'advice'    => array(
						'html' => esc_html__( 'You also need to change the global settings in Appearance -> Customize -> Alavion settings', 'alavion' ),
						'type'  => 'html',
					),	
					'items' => array(
						'label' => esc_html__( 'Theme Color Schemes', 'alavion' ),
						'type' => 'addable-box',
						'value' => array(),
						'desc' => esc_html__( 'Can be selected in page settings', 'alavion' ),
						'box-options' => array(
							'slug' => array(
								'label' => esc_html__( 'Scheme ID', 'alavion' ),
								'type' => 'text',
								'desc' => esc_html__( 'Required Field', 'alavion' ),
								'value' => '',
							),							
							'name' => array(
								'label' => esc_html__( 'Scheme Name', 'alavion' ),
								'desc' => esc_html__( 'Required Field', 'alavion' ),
								'type' => 'text',
								'value' => '',
							),
							'logo'    => array(
								'label' => esc_html__( 'Logo Black Background', 'alavion' ),
								'type'  => 'upload',
							),
							'logo_white'    => array(
								'label' => esc_html__( 'Logo White Background', 'alavion' ),
								'type'  => 'upload',
							),		
							'logo_2x'    => array(
								'label' => esc_html__( 'Logo Black Background 2x', 'alavion' ),
								'type'  => 'upload',
							),
							'logo_white_2x'    => array(
								'label' => esc_html__( 'Logo White Background 2x', 'alavion' ),
								'type'  => 'upload',
							),		
							'main-color'  => array(
								'label' => esc_html__( 'Main Color', 'alavion' ),
								'type'  => 'color-picker',
							),
							'second-color' => array(
								'label' => esc_html__( 'Second Color', 'alavion' ),
								'type'  => 'color-picker',
							),
							'gray-color' => array(
								'label' => esc_html__( 'Gray Color', 'alavion' ),
								'type'  => 'color-picker',
							),								
							'black-color' => array(
								'label' => esc_html__( 'Black Color', 'alavion' ),
								'type'  => 'color-picker',
							),	
							'white-color' => array(
								'label' => esc_html__( 'White Color', 'alavion' ),
								'type'  => 'color-picker',
							),								
						),
						'template' => '{{- name }}',
					),
				),
			),
		),
	),	
	'popup' => array(
		'title'   => esc_html__( 'Popup', 'alavion' ),
		'type'    => 'tab',
		'options' => array(
			'popup-box' => array(
				'title'   => esc_html__( 'Popup settings', 'alavion' ),
				'type'    => 'box',
				'options' => array(						
					'popup-status'    => array(
						'label'   => esc_html__( 'Status', 'alavion' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled', 'alavion' ),
							'enabled'  => esc_html__( 'Enabled', 'alavion' ),
						),
						'value' => 'disabled'
					),						
					'popup-hours'    => array(
						'label' => esc_html__( 'Period hidden, days', 'alavion' ),
						'type'  => 'text',
						'value'	=>	'24',
					),						
					'popup-text'    => array(
						'label' => esc_html__( 'Popup text', 'alavion' ),
						'type'  => 'wp-editor',
					),
					'popup-bg'    => array(
						'label' => esc_html__( 'Popup Background', 'alavion' ),
						'type'  => 'upload',
					),					
					'popup-yes'    => array(
						'label' => esc_html__( 'Yes button', 'alavion' ),
						'type'  => 'text',
						'value'	=>	'Yes',
					),	
					'popup-no'    => array(
						'label' => esc_html__( 'No button', 'alavion' ),
						'type'  => 'text',
						'value'	=>	'No',
					),																
					'popup-no-link'    => array(
						'label' => esc_html__( 'No link', 'alavion' ),
						'type'  => 'text',
						'value'	=>	'https://google.com',
					),																
				),	
			),
		),
	),
);

unset($options['colors']);
unset($options['popup']);
unset($options['header']['header-box-topbar']);

if ( function_exists('ltx_share_buttons_conf') ) {

	$share_links = ltx_share_buttons_conf();

	$share_links_options = array();
	if ( !empty($share_links) ) {

		$share_links_options = array(

			'share_icons_hide' => array(
                'label' => esc_html__( 'Hide all share icons block', 'alavion' ),
                'type'  => 'checkbox',
                'value'	=>	false,
            ),
		);
		foreach ( $share_links as $key => $item ) {

			$state = fw_get_db_settings_option( 'share_icon_' . $key );

			$value = false;
			if ( is_null($state) AND $item['active'] == 1 ) {

				$value = true;
			}

			$share_links_options[] =
			array(
				'share_icon_'.$key => array(
	                'label' => $item['header'],
	                'type'  => 'checkbox',
	                'value'	=>	$value,
	            ),
			);
		}
	}

	$share_links_options['share-add'] = array(

        'label' => esc_html__( 'Custom Share Buttons', 'alavion' ),
        'type' => 'addable-box',
        'value' => array(),
        'desc' => esc_html__( 'You can use {link} and {title} variables to set url. E.g. "http://www.facebook.com/sharer.php?u={link}"', 'alavion' ),
        'box-options' => array(
            'icon' => array(
                'label' => esc_html__( 'Icon', 'alavion' ),
                'type'  => 'icon-v2',
            ),
            'header' => array(
                'label' => esc_html__( 'Header', 'alavion' ),
                'type' => 'text',
            ),
            'link' => array(
                'label' => esc_html__( 'Link', 'alavion' ),
                'type' => 'text',
                'value' => '',
            ),		  
            'color' => array(
                'label' => esc_html__( 'Color', 'alavion' ),
                'type' => 'color-picker',
                'value' => '',
            ),		              
        ),
		'template' => '{{- header }}',		                
    );

	$options['social']['options']['share-box'] = array(
		'title'   => esc_html__( 'Share Buttons', 'alavion' ),
		'type'    => 'tab',
		'options' => $share_links_options,
	);
}

